# Player Config ID: huggingface_DeepSeek-V3-0324_PayoffMaximizer_A (as Player A)
# Meta-Round: 10
# Experiment: PMxPM, Run: 4
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek-V3-0324_PayoffMaximizer_A_MR10_strategy.txt
# LLM Suggested Fallback: D

def shadow_gambit(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    if not my_history:  # Round 1
        return "D"
    
    current_round = len(my_history) + 1
    
    # Check for unconditional strategies in opponent's code
    always_c = "return 'c'" in opponent_program_code.lower() or "always cooperate" in opponent_program_code.lower()
    always_d = "return 'd'" in opponent_program_code.lower() or "always defect" in opponent_program_code.lower()
    if always_c or always_d:
        return "D"
    
    if current_round <= 3:  # Initial Phase
        return "D"
    elif current_round <= 6:  # Middle Phase
        if any(move == "D" for move in opp_history[:3]):
            return "D"
        else:
            if current_round == 4:
                return "C"
            else:
                if opp_history[3] == "D":
                    return "D"
                else:
                    return "C"
    else:  # Late Phase
        if all(move == "C" for move in opp_history[3:6]):
            return "D" if current_round % 2 == 0 else "C"
        else:
            return "D"